% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simul_fun_generalized_2d.R
\name{simul_fun_generalized_2d}
\alias{simul_fun_generalized_2d}
\title{A Special Case of simulation_generalized in 2 Dimensions}
\usage{
simul_fun_generalized_2d(
  nsim,
  n_train,
  n_test,
  copula,
  init_params,
  fn,
  u1,
  u2,
  z1_train,
  z2_train,
  X_t,
  y1_test,
  y2_test,
  BSTS_1,
  BSTS_2
)
}
\arguments{
\item{nsim}{Integer, number of simulation replications.}

\item{n_train}{Integer, number of training observations.}

\item{n_test}{Integer, number of test observations.}

\item{copula}{Character, specifying the copula type: "Clayton", "Frank",
"Gumbel", "Joe", or "Gaussian".}

\item{init_params}{Numeric vector, initial parameter values for optimization.}

\item{fn}{Function, log-likelihood function for parameter estimation.}

\item{u1}{Numeric vector (n_train), first pseudo-observation for the copula.}

\item{u2}{Numeric vector (n_train), second pseudo-observation for the copula.}

\item{z1_train}{Numeric matrix (n_train x M), observed data for the first margin.}

\item{z2_train}{Numeric matrix (n_train x M), observed data for the second margin.}

\item{X_t}{Numeric matrix (n_train x M), risk factors for the dynamic copula parameter.}

\item{y1_test}{Numeric vector (n_test), true future values for the first response variable.}

\item{y2_test}{Numeric vector (n_test), true future values for the second response variable.}

\item{BSTS_1}{Fitted BSTS model for the first response variable.}

\item{BSTS_2}{Fitted BSTS model for the second response variable.}
}
\value{
A list containing:
\item{theta_simulated}{Simulated copula parameters across replications.}
\item{y1_simulated}{Simulated values for the first response variable.}
\item{y2_simulated}{Simulated values for the second response variable.}
\item{MSE}{Mean squared error for each simulation run.}
\item{optim_results}{Results from the optimization process.}
}
\description{
A Special Case of simulation_generalized in 2 Dimensions
}
