test_that("simulation_generalized runs correctly with valid inputs", {
  # Set seed for reproducibility
  set.seed(123)
  # Define dimensions
  nsim <- 10      # Number of simulation replications
  D <- 2           # Number of margins
  M <- 5           # Number of covariates
  # Generate synthetic data
  params <- init_params_full_G #  parameters
  U_train <-uu        # Pseudo-observations
  Z_train <- zz_train      # Covariate data
  X <- xx_train              # Risk factors
  Y_test <- yy_test           # True future values
  n.iter <- 10
  # Generate mock BSTS models (for simplicity, we create empty placeholders)
  bsts_Dufferin <- fit_bsts(yy_train[,1], zz_train[,1,], lags = 2, MCMC.iter = n.iter) # Dufferin
  bsts_Wellington <- fit_bsts(yy_train[,2], zz_train[,2,], lags = 2, MCMC.iter = n.iter) # Wellington
  BSTS_list <- list(bsts_Dufferin,bsts_Wellington)
  result <- simulation_generalized(nsim, n_train, n_test, "Gumbel", params,
                                     log_likelihood_Generalized, U_train, Z_train, X, Y_test, BSTS_list)
  # Check that output is a list
  expect_type(result, "list")
  expect_named(result, c("optim_results", "theta_sim", "Y_sim", "MSE"))
  # Check optimization result structure
  expect_type(result$optim_results, "list")
  # Check that theta_sim has the correct structure
  expect_equal(dim(result$theta_sim), c(nsim, n_test))
  # Check Y_sim structure
  expect_equal(dim(result$Y_sim), c(nsim, n_test, D))
  # Check MSE values
  expect_equal(length(result$MSE), nsim)
  expect_type(result$MSE, "double")
  expect_true(all(result$MSE >= 0))  # MSE should be non-negative
})
