% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_likelihood_noGEV_3d.R
\name{log_likelihood_noGEV_3d}
\alias{log_likelihood_noGEV_3d}
\title{Log-Likelihood Function for 3D Copula Model}
\usage{
log_likelihood_noGEV_3d(params, u1, u2, u3, X_t, z1, z2, z3, copula)
}
\arguments{
\item{params}{Numeric vector, model parameters.}

\item{u1}{Numeric vector (length \code{n_train}), pseudo-observations for margin 1.}

\item{u2}{Numeric vector (length \code{n_train}), pseudo-observations for margin 2.}

\item{u3}{Numeric vector (length \code{n_train}), pseudo-observations for margin 3.}

\item{X_t}{Numeric matrix (\verb{n_train x M}), risk factors affecting copula parameters.}

\item{z1}{Numeric matrix (\verb{n_train x M}), observed data for margin 1.}

\item{z2}{Numeric matrix (\verb{n_train x M}), observed data for margin 2.}

\item{z3}{Numeric matrix (\verb{n_train x M}), observed data for margin 3.}

\item{copula}{Character, specifying the copula type: "Clayton", "Frank", "Gumbel", "Joe", or "Gaussian".}
}
\value{
The negative log-likelihood value for optimization.
}
\description{
Computes the negative log-likelihood of a 3-dimensional copula model with a
time-varying copula structure.
}
\examples{
test_ll_3d <- log_likelihood_noGEV_3d(init_params_full,
                                                u[[1]],
                                                u[[2]],
                                                u[[3]],
                                                (z_train[[1]] + z_train[[2]] + z_train[[3]])/3,
                                                z_train[[1]],
                                                z_train[[2]],
                                                z_train[[3]],
                                                "Gaussian")

}
