% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{enum}
\alias{enum}
\title{Enumerate items in an object.}
\usage{
enum(x)
}
\arguments{
\item{x}{Any object.}
}
\description{
`enum()` is creating a vector of integers to enumarate items in an object. It
is particularly useful in the `for(i in enum(object))` construct.
}
\note{
The pattern `for(i in 1:length(object))` is often found, but it fails
in case `length(object) == 0`! `enum()` is indeed a synonym of `seq_along()`,
but the later one is less  expressive in the context.
}
\examples{
enum(letters)
enum(numeric(0))
# Compare with:
1:length(numeric(0))
enum(NULL)
letters5 <- letters[1:5]
for (i in enum(letters5)) cat("letter", i, "=", letters5[i], "\n")
}
\seealso{
[seq_along()]
}
