% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\docType{data}
\name{nr}
\alias{nr}
\alias{nc}
\alias{ROWS}
\alias{COLS}
\title{Convenience functions for rows or columns manipulations.}
\format{
An object of class \code{numeric} of length 1.

An object of class \code{numeric} of length 1.
}
\usage{
nr(x)

nc(x)

ROWS

COLS
}
\arguments{
\item{x}{Any object.}
}
\description{
`nr()` and `nc()` are synonyms of the ugly `NROW()` or `NCOL()` that still
provide a result, even if `dim` attribute of the object is not set, on the
contrary to `nrow()`or `ncol()`. `ROWS` and `COLS` are constants that makes
call to `apply()` more expressive.
}
\examples{
mm <- matrix(1:6, nrow = 3)
nr(mm)
nc(mm)
vv <- 1:6
nr(vv)
nc(vv)
# ROWS and COLS constants used with apply()
apply(mm, ROWS, mean) # Idem apply(mm, 1, mean)
apply(mm, COLS, mean) # Idem apply(mm, 2, mean)
}
\seealso{
[NROW()]
}
\keyword{datasets}
