% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panels.diag.R
\name{panels.diag}
\alias{panels.diag}
\alias{panel_boxplot}
\alias{panel.boxplot}
\alias{panel_density}
\alias{panel.density}
\alias{panel_hist}
\alias{panel.hist}
\alias{panel_qqnorm}
\alias{panel.qqnorm}
\title{More univariate panel plots.}
\usage{
panel_boxplot(x, col = par("col"), box.col = "cornsilk", ...)

panel.boxplot(x, col = par("col"), box.col = "cornsilk", ...)

panel_density(
  x,
  adjust = 1,
  rug = TRUE,
  col = par("col"),
  lwd = par("lwd"),
  line.col = col,
  line.lwd = lwd,
  ...
)

panel.density(
  x,
  adjust = 1,
  rug = TRUE,
  col = par("col"),
  lwd = par("lwd"),
  line.col = col,
  line.lwd = lwd,
  ...
)

panel_hist(
  x,
  breaks = "Sturges",
  hist.col = "cornsilk",
  hist.border = NULL,
  hist.density = NULL,
  hist.angle = 45,
  ...
)

panel.hist(
  x,
  breaks = "Sturges",
  hist.col = "cornsilk",
  hist.border = NULL,
  hist.density = NULL,
  hist.angle = 45,
  ...
)

panel_qqnorm(
  x,
  pch = par("pch"),
  col = par("col"),
  bg = par("bg"),
  cex = par("cex"),
  lwd = par("lwd"),
  qq.pch = pch,
  qq.col = col,
  qq.bg = bg,
  qq.cex = cex,
  qqline.col = qq.col,
  qqline.lwd = lwd,
  ...
)

panel.qqnorm(
  x,
  pch = par("pch"),
  col = par("col"),
  bg = par("bg"),
  cex = par("cex"),
  lwd = par("lwd"),
  qq.pch = pch,
  qq.col = col,
  qq.bg = bg,
  qq.cex = cex,
  qqline.col = qq.col,
  qqline.lwd = lwd,
  ...
)
}
\arguments{
\item{x}{A numeric vector.}

\item{col}{The color of the points.}

\item{box.col}{The filling color of the boxplots.}

\item{...}{Further arguments to plot functions, or functions that construct
items, like [stats::density()], depending on the context.}

\item{adjust}{The bandwidth adjustment factor, see [stats::density()].}

\item{rug}{Do we add a rug representation (1-d plot) of the points too?}

\item{lwd}{The line width.}

\item{line.col}{The color of the line.}

\item{line.lwd}{The width of the line.}

\item{breaks}{The number of breaks, the name of a break algorithm, a vector
of breakpoints, or any other acceptable value for `breaks =` argument of
[graphics::hist()].}

\item{hist.col}{The filling color for the histograms.}

\item{hist.border}{The border color for the histograms.}

\item{hist.density}{The density for filling lines in the histograms.}

\item{hist.angle}{The angle for filling lines in the histograms.}

\item{pch}{The symbol used for the points.}

\item{bg}{The background color for symbol used for the points.}

\item{cex}{The expansion factor used for the points.}

\item{qq.pch}{The symbol used to plot points in the QQ-plots.}

\item{qq.col}{The color of the symbol used to plot points in the QQ-plots.}

\item{qq.bg}{The background color of the symbol used to plot points in the
QQ-plots.}

\item{qq.cex}{The expansion factor for points in the QQ-plots.}

\item{qqline.col}{The color for the QQ-plot lines.}

\item{qqline.lwd}{The width for the QQ-plot lines.}
}
\value{
These functions return nothing and are used for their side effect of
plotting in panels of composite plots.
}
\description{
Several panel plots that can be used with [graphics::pairs()].
}
\details{
Panel functions [SciViews::panel_boxplot()], [SciViews::panel_density()], [SciViews::panel_hist()]
and [SciViews::panel_qqnorm()] should be used only to plot univariate data on the
diagonals of pair plots (or scatterplot matrix).
}
\examples{
# Example of scatterplot matrices with custom plots on the diagonal
# Boxplots
pairs(trees, panel = panel_smooth, diag.panel = panel_boxplot)
pairs(trees, diag.panel = panel_boxplot, box.col = "gray")
# Densities
pairs(trees, panel = panel_smooth, diag.panel = panel_density)
pairs(trees, diag.panel = panel_density, line.col = "red", adjust = 0.5)
# Histograms
pairs(trees, panel = panel_smooth, diag.panel = panel_hist)
pairs(trees, diag.panel = panel_hist, hist.col = "gray", breaks = "Scott")
# QQ-plots against Normal theoretical distribution
pairs(trees, panel = panel_smooth, diag.panel = panel_qqnorm)
pairs(trees, diag.panel = panel_qqnorm, qqline.col = 2, qq.cex = .5, qq.pch = 3)
}
\seealso{
[graphics::pairs()], [graphics::boxplot()], [graphics::hist()], [stats::density()], [stats::qqnorm()]
}
\author{
Philippe Grosjean <phgrosjean@sciviews.org>, but code inspired from
`spm()` in package **car**.
}
\concept{panel plots}
\keyword{aplot}
