% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_computeLonLatFromOriginDistBearing}
\alias{seasonder_computeLonLatFromOriginDistBearing}
\title{Compute Geographic Coordinates from Origin, Distance, and Bearing}
\usage{
seasonder_computeLonLatFromOriginDistBearing(
  origin_lon,
  origin_lat,
  dist,
  bearing
)
}
\arguments{
\item{origin_lon}{A numeric value representing the longitude of the origin point in decimal degrees.}

\item{origin_lat}{A numeric value representing the latitude of the origin point in decimal degrees.}

\item{dist}{A numeric value representing the distance from the origin in kilometers.}

\item{bearing}{A numeric vector of bearings (in degrees) indicating the direction from the origin.}
}
\value{
A data frame with two columns:
\itemize{
\item \code{lon}: The longitude of the computed geographic coordinates.
\item \code{lat}: The latitude of the computed geographic coordinates.
}
}
\description{
This function calculates the geographic coordinates (latitude and longitude) for a given distance and bearing from a specified origin.
}
\details{
The function uses the geodetic formulas provided by the \code{geosphere} package to compute the destination point based on:
\itemize{
\item Origin longitude and latitude
\item Distance in meters (converted from kilometers)
\item Bearing in degrees
}

The calculation employs the \code{geosphere::destPoint} function, which handles the spherical geometry of the Earth.
}
\examples{
# Example with a point at 100 km to the north of the origin
result <- seasonder_computeLonLatFromOriginDistBearing(-123.3656, 48.4284, 100, 0)
print(result)
}
\seealso{
\code{\link[geosphere]{destPoint}}
}
