% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_getMUSICOptions}
\alias{seasonder_getMUSICOptions}
\title{Retrieve MUSIC Options from a SeaSondeRCS Object}
\usage{
seasonder_getMUSICOptions(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing MUSIC data as an attribute.}
}
\value{
A list of MUSIC options.
}
\description{
This function extracts the MUSIC options from a SeaSondeRCS object.
}
\details{
The function retrieves the MUSIC options from the object's MUSIC_data attribute.
In the absence of user-defined options, it returns the default options provided by \code{seasonder_defaultMUSICOptions()}.
}
\examples{
# Minimal example for seasonder_getMUSICOptions
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
opts <- seasonder_getMUSICOptions(cs_obj)
print(opts)
}
