% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_getSeaSondeRCS_FOR}
\alias{seasonder_getSeaSondeRCS_FOR}
\title{Retrieve First Order Region (FOR) Data from SeaSondeRCS Object}
\usage{
seasonder_getSeaSondeRCS_FOR(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing FOR-related data.}
}
\value{
The FOR data structure.
}
\description{
This function extracts the First Order Region (FOR) data from a SeaSondeRCS object.
If the FOR data is not found in the object's attributes, it is initialized using
\code{seasonder_initSeaSondeRCS_FOR()}.
}
\details{
The function attempts to retrieve the 'FOR' element from the object's "FOR_data" attribute.
If it does not exist, it calls \code{seasonder_initSeaSondeRCS_FOR()} to initialize the FOR data.
}
\examples{
# Minimal example for seasonder_getSeaSondeRCS_FOR
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
FOR_data <- seasonder_getSeaSondeRCS_FOR(cs_obj)
head(FOR_data)
}
