% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasonder_specsHandling.R
\name{seasonder_readYAMLSpecs}
\alias{seasonder_readYAMLSpecs}
\title{Read Specifications from a YAML File}
\usage{
seasonder_readYAMLSpecs(file_path, path = rlang::zap())
}
\arguments{
\item{file_path}{A string. The path to the YAML file.}

\item{path}{A character vector. Represents the path within the YAML file to
access the desired information. For example, to access fields of version V2
of the header, the path would be \code{c("header", "versions", "V2")}.}
}
\value{
A list. The information extracted from the YAML file based on the
provided path.
}
\description{
This function reads a YAML file containing specifications, handles potential
reading errors, and extracts specific information based on a provided path.
}
\details{
This function provides built-in error handling which aborts execution and logs
detailed error messages in case of:
\itemize{
\item File not found.
\item Error in reading the YAML content.
\item The read YAML content is not a list.
\item No data found for the provided path in the YAML content.
}

Errors generated are of class \code{"seasonder_read_yaml_file_error"}. For logging and aborting,
this function uses \code{\link[=seasonder_logAndAbort]{seasonder_logAndAbort}}.
}
\examples{
# Example: Read the CS header specifications (version V1) from the default specs file
specs_path <- seasonder_defaultSpecsFilePath("CS")
result <- seasonder_readYAMLSpecs(specs_path, c("header", "V1"))
str(result)
}
\seealso{
\code{\link[yaml]{read_yaml}} for the underlying YAML reading.

\code{\link[purrr]{pluck}} for the data extraction mechanism used.
}
