% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_setMUSICOptions}
\alias{seasonder_setMUSICOptions}
\title{Set MUSIC Options for a SeaSondeRCS Object}
\usage{
seasonder_setMUSICOptions(
  seasonder_cs_object,
  MUSIC_options = seasonder_defaultMUSICOptions()
)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object that contains the MUSIC data as an attribute.}

\item{MUSIC_options}{A named list of MUSIC options. Defaults to the output of \code{seasonder_defaultMUSICOptions()}.}
}
\value{
The updated SeaSondeRCS object with the MUSIC options stored in its MUSIC data attribute.
}
\description{
This function updates the MUSIC options stored in a SeaSondeRCS object's MUSIC data attribute.
It merges the provided options with the default MUSIC options, ensuring that any missing fields
are filled with the defaults.
}
\details{
The function uses \code{modifyList} to merge the default MUSIC options with any user-specified options.
This ensures that the resulting options list contains all required fields.
}
\examples{
# Example: update MUSIC options on a minimal CS object
header <- list(nRangeCells = 1, nDopplerCells = 1)
data <- list(
  SSA1 = matrix(0,1,1), SSA2 = matrix(0,1,1), SSA3 = matrix(0,1,1),
  CS12 = matrix(complex(real=0,imaginary=0),1,1),
  CS13 = matrix(complex(real=0,imaginary=0),1,1),
  CS23 = matrix(complex(real=0,imaginary=0),1,1), QC = matrix(0,1,1)
)
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_obj <- seasonder_createSeaSondeRCS(list(header = header, data = data), 
seasonder_apm_object = apm_obj)
cs_obj <- seasonder_setMUSICOptions(cs_obj, list(doppler_interpolation = 3))
opts <- seasonder_getMUSICOptions(cs_obj)
print(opts)
}
