% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmtin.R
\name{rmtin}
\alias{rmtin}
\title{Random number generation for the MTIN distribution}
\usage{
rmtin(n, mu = rep(0, d), Sigma, theta = 0.01)
}
\arguments{
\item{n}{An integer specifying the number of data points to be simulated.}

\item{mu}{A vector of length \code{d}, where \code{d} is the dimensionality, representing the mean value.}

\item{Sigma}{A symmetric positive-definite matrix representing the scale matrix of the distribution.}

\item{theta}{A number between 0 and 1 indicating the tailedness parameter.}
}
\value{
A list with the following elements:
\item{X}{A data matrix with \code{n} rows and \code{d} columns.}
\item{w}{A vector of weights of dimension \code{n}.}
}
\description{
Random number generation for the MTIN distribution
}
\examples{
d <- 3
rmtin(10, mu = rep(0, d), Sigma = diag(d), theta = 0.9)
}
\references{
Punzo A., and Bagnato L. (2021). The multivariate tail-inflated normal distribution and its application in finance.
\emph{Journal of Statistical Computation and Simulation}, \strong{91}(1), 1-36.
}
