% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.SensIAT_fulldata_jackknife_results}
\alias{autoplot.SensIAT_fulldata_jackknife_results}
\title{Plot for Estimated Treatment Effect for \code{SensIAT_fulldata_jackknife_results} Objects}
\usage{
\method{autoplot}{SensIAT_fulldata_jackknife_results}(object, ..., include.rugs = NA)
}
\arguments{
\item{object}{A \code{SensIAT_fulldata_jackknife_results} object.}

\item{...}{Additional arguments passed to \code{predict}.}

\item{include.rugs}{If \code{TRUE}, adds rugs to the plot. If \code{FALSE}, no rugs are added.
When \code{NA}, rugs are added only if the number of distinct values of \code{alpha_control}
and \code{alpha_treatment} is less than or equal to 10.}
}
\description{
The horizontal and vertical axes represent the sensitivity parameter \code{alpha}
for the control and treatment groups, respectively. The plot shows
at each combination of \code{alpha} values zero if the 95\% confidence interval
contains zero, otherwise the bound of the confidence interval that is closest
to zero.
}
\examples{
# Note: fitting the jackknife is computationally expensive,
#       so this example is here for reference.
\dontrun{
full.object <-
    fit_SensIAT_fulldata_model(
        data = SensIAT_example_fulldata,
        trt = Treatment_group == 'treatment',
        outcome_modeler = fit_SensIAT_single_index_fixed_coef_model,
        id = Subject_ID,
        outcome = Outcome,
        time = Time,
        knots = c(60, 260, 460),
        alpha = c(-0.6, -0.3, 0, 0.3, 0.6)
    )
jk.full.model <- jackknife(full.object, time = 180)
ggplot2::autoplot(jk.full.model)
}
}
