% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.SensIAT_fulldata_model}
\alias{autoplot.SensIAT_fulldata_model}
\title{Plot for Estimated Treatment Effect for \code{SensIAT_fulldata_model} Objects}
\usage{
\method{autoplot}{SensIAT_fulldata_model}(object, time, include.rugs = NA, ...)
}
\arguments{
\item{object}{A \code{SensIAT_fulldata_model} object.}

\item{time}{Time at which to plot the estimates.}

\item{include.rugs}{If \code{TRUE}, adds rugs indicating the locations where the
sensitivity was evaluated to the plot. If \code{FALSE}, no rugs are added.
If \code{NA}, rugs are added only if the number of distinct values of
\code{alpha_control} and \code{alpha_treatment} is less than or equal to 10.}

\item{...}{Additional arguments passed to \code{predict}.}
}
\value{
A \code{ggplot2} object.
}
\description{
The horizontal and vertical axes represent the sensitivity parameter \code{alpha}
for the control and treatment groups, respectively. The contour plot shows
the estimated treatment effect at each combination of \code{alpha} values.
}
\examples{
\donttest{
full.object <-
    fit_SensIAT_fulldata_model(
        data = SensIAT_example_fulldata,
        trt = Treatment_group == 'treatment',
        outcome_modeler = fit_SensIAT_single_index_fixed_coef_model,
        id = Subject_ID,
        outcome = Outcome,
        time = Time,
        knots = c(60, 260, 460),
        alpha = c(-0.6, -0.3, 0, 0.3, 0.6)
    )
ggplot2::autoplot(full.object, time = 180)
}
}
