% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.alignment}
\alias{plot.alignment}
\title{Plot Alignment Matrix}
\usage{
\method{plot}{alignment}(x, ...)
}
\arguments{
\item{x}{Object of class \code{alignment} (see \code{\link{align_sequences}}).}

\item{...}{Additional parameters to be passed to the \code{plot()} function.}
}
\value{
Plot of the alignment matrix.
}
\description{
Produces a plot displaying the alignment matrix of \code{seq1} and \code{seq2}.
}
\details{
The first sequence (\code{seq1}) is represented by the columns and the second sequence (\code{seq2}) is represented
by the rows. The first column and first row are left bank, meaning a gap. Each cell in the matrix displays the score.
The subtitle states the \code{match}, \code{mismatch} and gap penalty \code{d} used in the algorithm.
A mismatch is shown by the red arrows, a match by the blue arrows, and a gap by the green arrows.
The alignment(s) with the highest score are highlighted with thick gray borders.
}
\examples{
seq1 <- "GCATGCG"
seq2 <- "GATTACA"
# Run the Needleman-Wunsch algorithm
alignment1 <- align_sequences(seq1, seq2, d = -1, mismatch = -1, match = 1)
# Plot the matrix
plot(alignment1)

}
\references{
The implementation is inspired by the visualization \href{https://gist.github.com/slowkow/508393}{(code)} by Kamil Slowikowski (\href{https://orcid.org/0000-0002-2843-6370}{ORCID}).
}
