% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_expression_matrices.R
\name{prepare_expression_matrices}
\alias{prepare_expression_matrices}
\title{Prepare Expression and Percentage Matrices from Seurat DotPlot}
\usage{
prepare_expression_matrices(
  seurat_object,
  features,
  group_by = "seurat_clusters",
  idents = NULL,
  split_pattern = "_",
  time_position = 1,
  celltype_start = 2
)
}
\arguments{
\item{seurat_object}{A Seurat object containing single cell data}

\item{features}{Character vector of gene names to plot}

\item{group_by}{Character string specifying the metadata column to group by (default: "seurat_clusters")}

\item{idents}{Numeric or character vector specifying which cell groups to include (default: NULL for all)}

\item{split_pattern}{Character string used to split column names for parsing (default: "_")}

\item{time_position}{Integer indicating position of time point in split names (default: 1)}

\item{celltype_start}{Integer indicating starting position of cell type in split names (default: 2)}
}
\value{
A list containing exp_mat (matrix of scaled expression values), percent_mat (matrix of expression percentages), and dotplot_data (original DotPlot data frame).
}
\description{
Extracts and reshapes expression data from a Seurat DotPlot object into
matrices suitable for complex heatmap visualization.
}
\examples{
# Load a small example Seurat object
data("pbmc_small", package = "SeuratObject")
features <- c("CD3D", "CD79A", "MS4A1")

# Basic usage
matrices <- prepare_expression_matrices(
  seurat_object = pbmc_small,
  features = features,
  group_by = "RNA_snn_res.0.8"
)

# Access the results
expression_matrix <- matrices$exp_mat
percentage_matrix <- matrices$percent_mat

}
\seealso{
\code{\link{create_single_cell_complex_heatmap}}
}
