% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spader.R
\name{SimilarityMult}
\alias{SimilarityMult}
\title{Estimation of multiple-community similarity measures}
\usage{
SimilarityMult(X, datatype = c("abundance", "incidence_freq",
  "incidence_raw"), units, q = 2, nboot = 200, goal = "relative")
}
\arguments{
\item{X}{a matrix/data.frame of species abundances/incidences.\cr}

\item{datatype}{type of input data, "abundance", "incidence_freq" or "incidence_raw". \cr}

\item{units}{number of sampling units in each community. For \code{datatype = "incidence_raw"}, users must specify the number of sampling units taken from each community. This argument is not needed for "abundance" and "incidence_freq" data. \cr}

\item{q}{a specified order to use to compute pairwise similarity measures. If \code{q = 0}, this function computes the estimated pairwise richness-based Jaccard and
Sorensen similarity indices.
If \code{q = 1} and \code{goal=relative}, this function computes the estimated pairwise equal-weighted and size-weighted Horn indices based on Shannon entropy;
If \code{q = 1} and \code{goal=absolute}, this function computes the estimated pairwise Shannon-entropy-based measure for comparing absolute abundances. If \code{q = 2} and \code{goal=relative}, 
this function computes the estimated pairwise Morisita-Horn and regional species-overlap indices based on species relative abundances.
If \code{q = 2} and \code{goal=absolute}, 
this function computes the estimated pairwise Morisita-Horn and regional species-overlap indices based on species absolute abundances.}

\item{nboot}{an integer specifying the number of bootstrap replications.}

\item{goal}{a specified estimating goal to use to compute pairwise similarity measures:comparing species relative abundances (\code{goal=relative}) or comparing species absolute abundances (\code{goal=absolute}). \cr\cr}
}
\value{
a list of fourteen objects: \cr\cr
\code{$datatype} for showing the specified data types (abundance or incidence).\cr\cr
\code{$info} for summarizing data information.\cr\cr 
\code{$Empirical_richness} for showing the observed values of the richness-based similarity indices
include the classic \eqn{N}-community Jaccard and Sorensen indices. \cr\cr
\code{$Empirical_relative} for showing the observed values of the equal-weighted similarity indices
for comparing species relative abundances including Horn, Morisita-Horn and regional overlap measures. \cr \cr
\code{$Empirical_WtRelative} for showing the observed value of the Horn similarity index for comparing
size-weighted species relative abundances based on Shannon entropy under equal-effort sampling. \cr\cr
\code{$Empirical_absolute} for showing the observed values of the similarity indices for comparing
absolute abundances. These measures include the Shannon-entropy-based measure, Morisita-Horn and the regional species-overlap measures based on species absolute abundance, as well as the \eqn{N}-community Bray-Curtis index.
All measures are valid only under equal-effort sampling. \cr\cr
The corresponding four objects for showing the estimated similarity indices are:
\code{$estimated_richness}, \code{$estimated_relative}, \code{$estimated_WtRelative} and \code{$estimated_absolute}. \cr\cr
\code{$pairwise} and \code{$similarity.matrix} for showing respectively the pairwise dis-similarity
estimates (with related statistics) and the similarity matrix for various measures depending on the
diversity order \code{q} and the \code{goal} aspecified in the function arguments. \cr\cr
\code{$goal} for showing the goal specified in the argument goal (absolute or relative) used to compute pairwise similarity.\cr\cr
\code{$q} for showing which diversity order \code{q} specified to compute pairwise similarity. \cr\cr
}
\description{
\code{SimilarityMult}: Estimation various \eqn{N}-community similarity indices. The richness-based indices
include the classic \eqn{N}-community Jaccard and Sorensen indices; the abundance-based indices include the Horn, Morisita-Horn, regional species-overlap, and the \eqn{N}-community Bray-Curtis indices.
Three types of data are supported: Type (1) abundance data (datatype="abundance"), Type (2)
incidence-frequency data (datatype="incidence_freq"), and Type (2B) incidence-raw data
(datatype="incidence_raw"); see \code{SpadeR-package} details for data input formats.
}
\examples{
\dontrun{
data(SimilarityMultData)
# Type (1) abundance data 
SimilarityMult(SimilarityMultData$Abu,"abundance",q=2,nboot=200,"relative")
# Type (2) incidence-frequency data 
SimilarityMult(SimilarityMultData$Inci,"incidence_freq",q=2,nboot=200,"relative")
# Type (2B) incidence-raw data 
SimilarityMult(SimilarityMultData$Inci_raw,"incidence_raw",
units=c(19,17,15),q=2,nboot=200,"relative")
}
}
\references{
Chao, A., and Chiu, C. H. (2016). Bridging the variance and diversity decomposition approaches to beta diversity via similarity and differentiation measures. Methods in Ecology and Evolution, 7, 919-928. \cr\cr
Chao, A., Jost, L., Hsieh, T. C., Ma, K. H., Sherwin, W. B. and Rollins, L. A. (2015). Expected Shannon entropy and Shannon differentiation between subpopulations for neutral genes under the finite island model. Plos One, 10:e0125471.\cr\cr
Chiu, C. H., Jost, L. and Chao, A. (2014). Phylogenetic beta diversity, similarity, and differentiation measures based on Hill numbers. Ecological Monographs, 84, 21-44.\cr\cr
Gotelli, N. G. and Chao, A. (2013). Measuring and estimating species richness, species diver- sity,
and biotic similarity from sampling data. Encyclopedia of Biodiversity, 2nd Edition, Vol. 5, 195-211, Waltham, MA.
}

