% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupICA.R
\name{gen_groupPC}
\alias{gen_groupPC}
\title{Generate Group-Level Principal Components (PCs) for fMRI Data}
\usage{
gen_groupPC(
  bids_path,
  subj_list,
  n.comp = 30,
  ncore = 1,
  npc = 85,
  iter_std = 5,
  brainstructures = c("left", "right"),
  verbose = TRUE
)
}
\arguments{
\item{bids_path}{A character string specifying the root directory of the BIDS-formatted dataset.}

\item{subj_list}{A named list generated from \code{create_group_list} containing fMRI file paths for each subject.}

\item{n.comp}{An integer specifying the number of components to retain during group-level PCA. Default is 30.}

\item{ncore}{An integer specifying the number of cores to use for parallel processing. Default is 1.}

\item{npc}{An integer specifying the number of components to retain during subject-level PCA. Default is 85.}

\item{iter_std}{An integer specifying the number of iterative standardization steps to apply to fMRI data. Default is 5.}

\item{brainstructures}{A character vector specifying the brain structures to include in the analysis. Options are \code{"left"} (left cortex), \code{"right"} (right cortex), and/or \code{"subcortical"} (subcortex and cerebellum). Can also be \code{"all"} (obtain all three brain structures). Default is \code{c("left", "right")}.}

\item{verbose}{A logical value indicating whether to print convergence information during execution. Default is \code{TRUE}.}
}
\value{
A numeric matrix containing the group-level principal components, with dimensions determined by the number of retained components (\code{n.comp}) and the concatenated data across all subjects.
}
\description{
This function computes subject-level principal components (PCs) from fMRI data and performs a group-level PCA for dimension reduction, designed for cortical surface fMRI data in BIDS format.
}
\details{
NOTE: This function requires the \code{ciftiTools} package to be installed, and set up the path to the Connectome Workbench folder by \code{ciftiTools.setOption()}. See the package \code{ciftiTools} documentation for more information.
}
