% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_deriva.R
\name{deriva}
\alias{deriva}
\title{Derivatives of splines}
\usage{
deriva(object, epsilon = 1e-07)
}
\arguments{
\item{object}{\code{Splinets} object of the degree \code{k};}

\item{epsilon}{positive number, controls removal of knots from the support; If the derivative is smaller than this number, it is considered 
to be zero and the corresponding knots are removed from the support.The default value is \code{1e-7}.}
}
\value{
A \code{Splinets}-object of the order \code{k-1} that also contains the updated information about the support set.
}
\description{
The function generates a \code{Splinets}-object which contains the first order
derivatives of all the splines from the input \code{Splinets}-object.
The function also verifies the support set of the output to provide the accurate information about 
the support sets by excluding regions over which the original function is constant.
}
\section{References}{

Liu, X., Nassar, H., Podg\eqn{\mbox{\'o}}{o}rski, K. "Dyadic diagonalization of positive definite band matrices and efficient B-spline orthogonalization." Journal of Computational and Applied Mathematics (2022) <https://doi.org/10.1016/j.cam.2022.114444>.


Podg\eqn{\mbox{\'o}}{o}rski, K. (2021) 
"\code{Splinets} -- splines through the Taylor expansion, their support sets and orthogonal bases." <arXiv:2102.00733>.

 Nassar, H., Podg\eqn{\mbox{\'o}}{o}rski, K. (2023) "Splinets 1.5.0 -- Periodic Splinets." <arXiv:2302.07552>
}

\examples{
#-------------------------------------------------------#
#--- Generating the deriviative functions of splines ---#
#-------------------------------------------------------#
n=13; k=4
set.seed(5)
xi=sort(runif(n+2)); xi[1]=0; xi[n+2]=1
spl=construct(xi,k,matrix(rnorm((n+2)*(k+1)),ncol=(k+1))) #constructing three splines
spl=gather(spl, construct(xi,k,matrix(rnorm((n+2)*(k+1)),ncol=(k+1)))) 
spl=gather(spl, construct(xi,k,matrix(rnorm((n+2)*(k+1)),ncol=(k+1)))) 
# calculate the derivative of splines
dspl = deriva(spl)
plot(spl)
plot(dspl)

#----------------------------------------------#
#--- Examples with different support ranges ---#
#----------------------------------------------#

n=25; k=3
xi=seq(0,1,by=1/(n+1));
set.seed(5)
#Defining support ranges for three splines
supp=matrix(c(2,12,4,20,6,25),byrow=TRUE,ncol=2)
#Initial random matrices of the derivative for each spline
SS1=matrix(rnorm((supp[1,2]-supp[1,1]+1)*(k+1)),ncol=(k+1)) 
SS2=matrix(rnorm((supp[2,2]-supp[2,1]+1)*(k+1)),ncol=(k+1)) 
SS3=matrix(rnorm((supp[3,2]-supp[3,1]+1)*(k+1)),ncol=(k+1)) 
spl=construct(xi,k,SS1,supp[1,]) #constructing the first correct spline
nspl=construct(xi,k,SS2,supp[2,])
spl=gather(spl,nspl) #the second and the first ones
nspl=construct(xi,k,SS3,supp[3,])
spl=gather(spl,nspl) #the third is added

der_spl = deriva(spl)
par(mar=c(1,1,1,1))
par(mfrow=c(2,1))
plot(der_spl)
plot(spl)
par(mfrow=c(1,1))
}
\seealso{
\code{\link{integra}} for generating the indefinite integral of a spline that can be viewed 
as the inverse operation to \code{deriva}; 
\code{\link{dintegra}} for the definite integral of a spline;
}
