% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitStMoMo.R
\name{extractCoefficientsFromGnm}
\alias{extractCoefficientsFromGnm}
\title{Extract the model coefficient}
\usage{
extractCoefficientsFromGnm(object, coefGnmModel, ages, years, cohorts,
  zeroWeigthAges, zeroWeigthYears, zeroWeigthCohorts)
}
\arguments{
\item{object}{an object of class \code{"StMoMo"} defining the stochastic
mortality model.}

\item{coefGnmModel}{fitted coefficient from a gnm model fit.}

\item{ages}{ages in the fitting data.}

\item{years}{years in the fitting data.}

\item{cohorts}{cohorts in the fitting data.}

\item{zeroWeigthAges}{character vector of years whose parameters cannot 
be estimated because all data is zero weighted}

\item{zeroWeigthYears}{character vector of years whose parameters cannot 
be estimated because all data is zero weighted}

\item{zeroWeigthCohorts}{character vector of cohort whose parameters 
cannot be estimated because all data is zero weighted}
}
\value{
A list with the model parameters, ax, bx, kt, b0x, gc
}
\description{
Extract the model coefficient of a stochastic mortality model from
a gnm fit of the model
}
\details{
Weight vectors wx, wx, wc are used to identify parameters that
cannot be estimated because all the data is weighted out.
}
\keyword{internal}
