% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iarima.R
\name{iarima}
\alias{iarima}
\title{Fit independent arima series to a multivariate time series}
\usage{
iarima(x, order = NULL, include.constant = TRUE, ...)
}
\arguments{
\item{x}{numeric matrix with a multivariate time series.
Series are arranged in rows with columns representing time.}

\item{order}{an optional matrix with one row per time series
specifying the ARIMA models: for the ith row the three 
components \eqn{(p, d, q)} are the AR order, the degree of 
differencing, and the MA order. If absent the arima models 
are fitted using \code{\link[forecast]{auto.arima}}.}

\item{include.constant}{an optional vector of logical values 
indicating if the ARIMA model for the ith series should include a 
constant value. The default is \code{TRUE}. This parameter is ignored
if \code{order} is \code{NULL}.}

\item{...}{additional parameters for \code{\link[forecast]{auto.arima}}}
}
\value{
an object of class \code{"iarima"} with components:
\item{models}{a list with the arima models fitted to each time 
series.}
\item{x}{the original time series.}
}
\description{
Fits independent arima series to \code{x}, a multivariate 
time series.
}
\details{
The fitting of the ARIMA models for each time series is done with 
function \code{\link[forecast]{Arima}} from package 
\pkg{forecast}. See the latter function for further details on 
input arguments \code{kt.order} and \code{kt.include.constant}.
}
