\name{model}
\alias{model}

\title{model}

\description{
This function applies the proposed method of Hermes (2025) on a given set of ratings, user covariates and item covariates. This implementation allows for the same flexibility as in the Hermes (2025) paper, namely linear and bilinear predictors, sparsity and latent factors. Returns posterior samples for the parameter estimates and posterior predictive samples for the missing ratings.
}
\usage{
model(X, Y, R, k, l, method, sparse, mcmc_samples, burnin, verbose)}
\arguments{
  \item{X}{A \eqn{n \times p} user covariate matrix, where \eqn{n} is the number of users and \eqn{p} is the number of user covariates.}
  \item{Y}{A \eqn{m \times q} item covariate matrix, where \eqn{m} is the number of items and \eqn{q} is the number of item covariates.}
  \item{R}{A \eqn{n \times m} rating matrix, where missing ratings are encoded as 0 and observed ratings are encoded to be in \eqn{\{1,\ldots,k\}}.}
  \item{k}{Integer value indicating the maximum rating that a user can provide.}
  \item{l}{Number of latent factors.}
  \item{method}{Method choice, either \code{linear} or \code{bilinear}.}
  \item{sparse}{Boolean value indicating whether sparsity should be imposed on \eqn{\mathbf{B}} (\code{TRUE}) or not (\code{FALSE}).}
  \item{mcmc_samples}{Total number of Gibbs samples.}
  \item{burnin}{Number of Gibbs samples that are used as burnin.}
  \item{verbose}{Boolean value indicating whether parameter estimation progress is returned (\code{TRUE}) or not (\code{FALSE}).}
}

\value{
\item{B_hat}{A \eqn{p \times q \times} (\code{mcmc_samples} - \code{burnin}) array consisting of the post-burnin samples for the coefficients of the user and item covariates.}
\item{U_hat}{A \eqn{n \times l \times} (\code{mcmc_samples} - \code{burnin}) array consisting of the post-burnin samples for the user latent factors (only applicable if \eqn{l > 0}).}
\item{V_hat}{A \eqn{m \times l \times} (\code{mcmc_samples} - \code{burnin}) array consisting of the post-burnin samples for the item latent factors (only applicable if \eqn{l > 0}).}
\item{R_hat}{A \eqn{n \times m \times} (\code{mcmc_samples} - \code{burnin}) array consisting of the post-burnin posterior predictive samples for the missing ratings.}
}

\references{
1. Hermes, S. (2025). A Statistical Interpretation of Multi-Item Rating and Recommendation Problems. arXiv preprint, arXiv:2503.02786. \cr
}

\author{
  Sjoerd Hermes\cr
  Maintainer: Sjoerd Hermes \email{sjoerd.hermes@wur.nl}
}

\examples{
# Set parameters
n = m = 15
p = q = 3
method = "linear"
k = 5
l = 1
sparse = TRUE

# Generate some data
# this is completely random, and there is no relation between the ratings
# and the covariates or latent factors
set.seed(2025)  
r = matrix(rbinom(n*m, k, 0.3), n, m)
X = matrix(rnorm(n * p), n, p)
Y = matrix(rnorm(m * q), m, q)

# Fit the model on the data
est = model(X, Y, r, k, l, method, sparse, mcmc_samples = 2000, burnin = 1000, TRUE)
}

