% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StepGWR_exponential.R
\name{StepGWR_exponential}
\alias{StepGWR_exponential}
\title{StepGWR: a hybrid spatial model that combines the variable selection capabilities of stepwise regression with the predictive power of Geographically Weighted Regression (GWR) model}
\usage{
StepGWR_exponential(data_sp, bw, split_value, exponential_kernel)
}
\arguments{
\item{data_sp}{A dataframe containing a response variable and the predictor variables, as well as the coordinates of the locations. In the dataframe, first column is the response variable (y), last two columns are coordinates i.e., Latitude and Longitudes and in between them is the set of predictor variables(X's).}

\item{bw}{A numeric value specifying the bandwidth parameter for the GWR model. It can be noted that, optimum bandwidth parameter value can vary and depends on the spatial pattern of the dataset.}

\item{split_value}{Splitting value for dividing the dataset into training and testing set, e.g. 0.8 or 0.7}

\item{exponential_kernel}{Spatial weight function of the GWR model, e.g. exponential_kernel}
}
\value{
A list with the following components:
  - `Important_vars `: Selected important variables based on stepwise regression
  - `GWR_y_pred_test`: The predicted values based on GWR at test locations
  - `rrmse`: root means square error
  - `R_squared`: R square value
  - `mse`: mean squared error
  - `mae`: mean absolute error
}
\description{
StepGWR: a hybrid spatial model that combines the variable selection capabilities of stepwise regression with the predictive power of Geographically Weighted Regression (GWR) model
}
\examples{
n<- 100
p<- 7
m<-sqrt(n)
id<-seq(1:n)
x<-matrix(runif(n*p), ncol=p)
e<-rnorm(n, mean=0, sd=1)
xy_grid<-expand.grid(c(1:m),c(1:m))
Latitude<-xy_grid[,1]
Longitude<-xy_grid[,2]
B0<-(Latitude+Longitude)/6
B1<-(Latitude/3)
B2<-(Longitude/3)
B3<-(2*Longitude)
B4<-2*(Latitude+Longitude)/6
B5<-(4*Longitude/3)
B6<-2*(Latitude+Longitude)/18
B7<-(4*Longitude/18)
y<-B0+(B1*x[,1])+(B2*x[,2])+(B3*x[,3])+(B4*x[,4])+(B5*x[,5])+(B6*x[,6])+(B7*x[,7])+e
data_sp<-data.frame(y,x,Latitude,Longitude)
StepGWR_exp<-StepGWR_exponential(data_sp,0.5,0.8,exponential_kernel)
}
\references{
1. Leung, Y., Mei, C. L. and Zhang, W. X. (2000). Statistical tests for spatial non-stationarity based on the geographically weighted regression model. Environment and Planning A, 32(1),9-32.<DOI:10.1068/a3162>.
2. Brunsdon, C., Fotheringham, A.S. and Charlton, M,E. (1996).Geographically weighted regression: a method for exploring spatial non-stationarity. Geogr Anal.28(4),281-298.<DOI:10.1111/j.1538-4632.1996.tb00936.x>.
}
