% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upgrade_usms_xml.R
\name{upgrade_usms_xml}
\alias{upgrade_usms_xml}
\title{Upgrading a usms.xml file to a newer version}
\usage{
upgrade_usms_xml(
  file,
  out_dir,
  param_gen_file,
  obs_dir = NULL,
  stics_version = "V9.2",
  target_version = "V10.0",
  check_version = TRUE,
  overwrite = FALSE
)
}
\arguments{
\item{file}{Path of a usms.xml file}

\item{out_dir}{Output directory path of the generated file}

\item{param_gen_file}{Path of the param_gen.xml file corresponding
to the file version}

\item{obs_dir}{Directory path of the observation data files}

\item{stics_version}{Name of the STICS version (VX.Y format)}

\item{target_version}{Name of the STICS version to upgrade files
to (VX.Y format)}

\item{check_version}{Perform version consistency with in stics_version input
with the file version and finally checking if the upgrade is possible
allowed to the target_version. If TRUE, param_gen_file is mandatory.}

\item{overwrite}{logical (optional),
TRUE for overwriting file if it exists, FALSE otherwise}
}
\value{
None
}
\description{
Upgrading a usms.xml file to a newer version
}
\details{
See get_stics_versions_compat() for listing versions
}
\examples{

dir_path <- get_examples_path(file_type = "xml", stics_version = "V9.2")

upgrade_usms_xml(
  file = file.path(dir_path, "usms.xml"),
  out_dir = tempdir(),
  param_gen_file = file.path(dir_path, "param_gen.xml")
)

}
