% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{skew.normal_fit}
\alias{skew.normal_fit}
\title{Fit Skew Normal Distribution to a vector of returns/stock prices.}
\usage{
skew.normal_fit(vec)
}
\arguments{
\item{vec}{a numeric vector containing the data to be fitted.}
}
\value{
a list containing the following elements:
\describe{
\item{params}{a numeric vector of length 3 containing the estimated values for the parameters of the
fitted distribution: location (mu), scale (sigma), and skewness (alpha).}
\item{aic}{the Akaike information criterion (AIC) value for the fitted distribution.}
\item{bic}{the Bayesian information criterion (BIC) value for the fitted distribution.}
}
}
\description{
This function fits the Skew Normal distribution to a given data vector using the \code{snormFit} function from
the \code{fGarch} package. It returns the estimated parameters along with the AIC and BIC values for the fitted
distribution.
}
\examples{

stock_prices <- c(10, 11, 12, 13, 14, 17, 18)
returns <- diff(log(stock_prices))
skew.normal_fit(returns)


}
\seealso{
\code{\link{norm_fit}}, \code{\link{t_fit}}, \code{\link{cauchy_fit}}, \code{\link{ghd_fit}}, \code{\link{hd_fit}},
\code{\link{sym.ghd_fit}}, \code{\link{sym.hd_fit}}, \code{\link{vg_fit}}, \code{\link{sym.vg_fit}},
\code{\link{nig_fit}}, \code{\link{ged_fit}}, \code{\link{skew.t_fit}},
\code{\link{skew.ged_fit}}
}
