% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defStormsList.R
\docType{methods}
\name{getLOI}
\alias{getLOI}
\alias{getLOI,stormsList-method}
\title{Getting the location of interest}
\usage{
getLOI(sts)

\S4method{getLOI}{stormsList}(sts)
}
\arguments{
\item{sts}{\code{stormsList} object}
}
\value{
sf object.
}
\description{
The \code{getLOI()} functions returns the location of interest for the given \code{stormsList}.
}
\examples{
#Creating a stormsDataset
\donttest{
sds <- defStormsDataset()

#Getting storm track data for all storms near New Caledonia
sts <- defStormsList(sds=sds, loi = "New Caledonia")

#Getting the location of interest for the sts object
loi <- getLOI(sts)
}
}
