% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generate.compt.R
\name{generate.compt}
\alias{generate.compt}
\title{Simulate competing risks endpoints data where censoring depends on missing covariates.}
\usage{
generate.compt(n, beta1, beta2, phi, gamma, seed)
}
\arguments{
\item{n}{Sample Size.}

\item{beta1}{Regression Coefficients for the event of interest process (length of 3)}

\item{beta2}{Regression Coefficients for the event of competing risk process (length of 3).}

\item{phi}{Regression Coefficients for the censoring process (length of 3).}

\item{gamma}{Regression Coefficients for the missingness (length of 3).}

\item{seed}{A random seed for data generation.}
}
\value{
A data frame with missing values.
}
\description{
We are assuming three covariates, two continuous and one binary,
where we assume the first continous and the binary covariates have missing values, and the second continuous covariates is fully observed.
}
\examples{
# Simulate a data set with approximately 45\% censoring, 35\% cause 1,
# and 20\% causes 2, and half of the subjects with at least one missing covariates.
generate.compt(n = 100, beta1 = c(1,1,-1), beta2 = c(2, 2, -2),
phi= c(-1,-1,-0.5), gamma = c(1,1,1,-1), seed = 112358)
}
