% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indeptestDT.R
\name{indeptestDT}
\alias{indeptestDT}
\title{Testing quasi-independence between survival and truncation times}
\usage{
indeptestDT(y, l, r)
}
\arguments{
\item{y}{vector of event times}

\item{l}{vector of left truncation times}

\item{r}{vector of right truncation times}
}
\value{
\item{tau}{Conditional Kendall's tau for survival time and left truncation time and survival time and right truncation time}
\item{X2}{Chi-squared test statistic to test null hypothesis that survival and truncation times are quasi-independent. Default degrees of freedom (DF) is 2. If left and right truncation times perfectly correlated, DF = 1}
\item{p}{p-value for null hypothesis that survival and truncation times are quasi-independent}
}
\description{
This function tests for quasi-independence between the survival and truncation times.
The survival and truncation times must be quasi-independent to use coxDT and cdfDT.
}
\details{
Testing for quasi-independence between the survival and truncation times using the
conditional Kendall's tau introduced by Martin and Betensky (2005). More details are given in their paper.
}
\examples{
# Generating independent survival and truncation times
set.seed(123)
y=rnorm(30); l=min(y)-abs(rnorm(30)); r=max(y)+abs(rnorm(30))

indeptestDT(y,l,r)

# Null hypothesis not rejected ==> not enough evidence to reject quasi-independence assumption
}
\references{
Martin and Betensky (2005). Testing Quasi-Independence of Failure and Truncation Times via Conditional Kendall's Tau. JASA. 100(470):484-492.
}
