% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitialEstimates.R
\name{Initial.estimates}
\alias{Initial.estimates}
\title{Internal estimation}
\usage{
Initial.estimates(datan, gamma.I, X, B, beta, Btype)
}
\arguments{
\item{datan}{internal data only}

\item{gamma.I}{regression estimates using internal data only (datan)}

\item{X}{a vector of predictor that were used in the external study, e.g. X =
c('X1','X2','X3')}

\item{B}{a vector of covariates that were not used in the external study, e.g.
B=c('X4','B1','B2')}

\item{beta}{a vector of external model estimates, the vector order should be
the same as listed in X, e.g. names(beta) = c("int", "X1", "X2", "X3")}

\item{Btype}{a vector of type of B, either continuous or binary. If "continuous",
linear regression will be used; if "binary", logistic regression will be used.
More types can be implemented manually.}
}
\value{
a numeric vector of estimated coefficients of the target model for the given
external population. Assume the internal data contains p predictors. The vector is of
dimension (p+1), including the estimates of the intercept.
}
\description{
Calculate the initial estimates for external populations.
}
\examples{
#' data(initial_estimates_example)

datan = initial_estimates_example$datan
gamma.I = initial_estimates_example$gamma.I
beta = initial_estimates_example$beta

# calculate the initial gamma for population S=1
gamma.S1.origin = Initial.estimates(datan = datan, gamma.I = gamma.I, 
    X = c('X1', 'X2', 'X3'), B = c('X4', 'B1', 'B2'), 
    beta = beta, Btype = c('continuous', 'continuous', 'binary'))

}
\references{
Neuhaus, J. and Jewell, N. (1993). A geometric approach to assess bias due to
omitted covariates in generalized linear models. Biometrika 80,807–815.

Gu, T., Taylor, J.M.G. and Mukherjee, B. (2021) Regression
inference for multiple populations by integrating summary-level data using stacked
imputations \url{https://arxiv.org/abs/2106.06835}.
}
