% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mg.tdcm.R
\name{mg.tdcm}
\alias{mg.tdcm}
\title{Estimating the multigroup transition diagnostic classification model (TDCM)}
\usage{
mg.tdcm(
  data,
  q.matrix,
  num.time.points,
  rule = "GDINA",
  groups,
  group.invariance = TRUE,
  item.invariance = TRUE,
  progress = FALSE
)
}
\arguments{
\item{data}{a required \eqn{N \times T \times I} matrix. For each time point, binary item responses are in the columns.}

\item{q.matrix}{a required \eqn{I \times A} matrix indicating which items measure which attributes.}

\item{num.time.points}{the number of time points (i.e., measurement/testing occasions), integer \eqn{\ge 2}.}

\item{rule}{the specific DCM to be employed. Currently accepts “GDINA”, “ACDM”, “DINA”, “GDINA1”, “GDINA2”, and so on. Default is “GDINA”, which is implemented with a logit link to estimate the LCDM. The “ACDM” rule will estimate the LCDM with only main effects. The “DINA” rule will estimate the DINA model. “GDINA1” will estimate the LCDM with only main effects, equivalent to “ACDM”. “GDINA2” will estimate the LCDM with up to two-way interaction effects. If rule is entered as a single string, that DCM will be assumed for each item. If entered as a vector, a DCM can be specified for each item.}

\item{groups}{A required vector of group identifiers for multiple group estimation.}

\item{group.invariance}{logical indicator for whether item parameter invariance should be assumed equal for all groups. Default = T. If specified as false, item parameters are not assumed equal for groups.}

\item{item.invariance}{logical indicator for whether item parameter invariance should be constrained to be equal at each time point. Default = T. If specified as false, item parameters are not assumed equal over time.}

\item{progress}{An optional logical indicating whether the function should print the progress of estimation.}
}
\value{
An object of class \code{gdina} with entries as indicated in the \pkg{CDM} package. For the TDCM-specific results (e.g., growth, transitions), results are summarized using the \code{\link{mg.tdcm.summary}} function.
}
\description{
This function estimates the multigroup TDCM (Madison & Bradshaw, 2018).
}
\note{
Currently, this function only accepts a single Q-matrix.
}
\examples{
\donttest{
## Example 4: G = 2, T = 2, A = 4
data(data.tdcm04, package = "TDCM")
data <- data.tdcm04$data
q.matrix <- data.tdcm04$q.matrix
groups <- data.tdcm04$groups

# Estimate full multigroup TDCM with invariance assumed.
mg.model <- TDCM::mg.tdcm(data, q.matrix, num.time.points = 2, groups = groups)

# summarize results
results <- TDCM::mg.tdcm.summary(mg.model, num.time.points = 2)

# plot results
TDCM::tdcm.plot(results)
}
}
\references{
Madison, M. J., & Bradshaw, L. (2018). Evaluating intervention effects in a diagnostic classification model framework. \emph{Journal of Educational Measurement, 55}(1), 32-51.
}
