% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FWpoint.numerical.with.regularization.R
\name{FWpoint.num.w.reg}
\alias{FWpoint.num.w.reg}
\title{Modified Fermat-Weber point numerical solver for ultrametrics}
\usage{
FWpoint.num.w.reg(datamatrix, penalty = 0)
}
\arguments{
\item{datamatrix}{matrix of dimension N*e, where N is the number of
observations which lie in R^e}

\item{penalty}{positive real number; the regularization rate}
}
\value{
vector; Fermat-Weber point approximation
}
\description{
Returns a modified Fermat-Weber point of N points using a gradient based
numerical method This method is appropriate for points coming from
ultrametrics. The algorithm tries to find a point that minimizes the sum of
tropical distances from the samples, but also also tries to find a point that
is as close as possible to the space of ultrametrics. The tradeoff between
these two objectives is controlled by the penalty parameter. If penalty=0,
the method is identical to FWpoint_numerical; it finds the Fermat-Weber
point, which may not be an ultrametric. If penalty is very large, the
algorithm is trying to find the Fermat-Weber point in the space of
ultrametrics.
}
\examples{
D = matrix(c(0,0,0,0,2,5,0,3,1),3,3,TRUE)
FWpoint.num.w.reg(D,1e4) # (0,2,5/3) not ultrametric
FWpoint.num.w.reg(D,1e4) # (0,5/3,5/3) ultrametric
}
\references{
Aliatimis, Georgios, Ruriko Yoshida, Burak Boyaci and James A.
Grant (2023). Tropical Logistic Regression on Space of Phylogenetic Trees
}
\author{
Georgios Aliatimis \email{g.aliatimis@lancaster.ac.uk}
}
