% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tropical.FW.R
\name{trop.FW}
\alias{trop.FW}
\title{Calculate the tropical Fermat-Weber point}
\usage{
trop.FW(A)
}
\arguments{
\item{A}{matrix with normalized tropical points as rows}
}
\value{
numeric vector providing the tropical Fermat-Weber point for the
tropical polytope
}
\description{
This function calculates the Fermat-Weber point for a tropical polytope
}
\examples{
P <-matrix(c(0,0,0,0,2,5,0,3,1),3,3,TRUE)

trop.FW(P)

}
\references{
Lin, Bo and Ruriko Yoshida (2016). Tropical Fermat-Weber Points.
SIAM J. Discret. Math. 32: 1229-1245.
}
\author{
David Barnhill \email{david.barnhill@nps.edu}
}
