% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dissim.R
\name{dissim}
\alias{dissim}
\title{Overlap-Based Functional Dissimilarity and its Decomposition}
\usage{
dissim(x = NULL)
}
\arguments{
\item{x}{Either an object of class "TPDcomm", generated with the \code{\link{TPDc}} function, containing the TPDc of the considered communities, or an object of class "TPDsp", generated with the \code{\link{TPDs}} or \code{\link{TPDsMean}} functions, containing the TPDs of the considered populations or species.}
}
\value{
\code{dissim} returns the overlap-based functional dissimilarity between all pairs of populations/species/communities, along with the decomposition of dissimilarity between shared and non-shared trait volume.
}
\description{
\code{dissim} calculates the  functional  dissimilarity between pairs of communities or populations, as well as its decomposition into shared and non-shared trait volume.
}
\examples{
# 1.  Compute the TPDs of three different species:
traits_iris <- iris[, c("Sepal.Length", "Sepal.Width")]
sp_iris <- iris$Species
TPDs_iris <- TPDs(species = sp_iris, traits_iris)

 #2. Compute the TPDc of three different communities:
abundances_comm_iris <- matrix(c(c(0.9, 0.1, 0), #I. setosa dominates
                         c(0.0, 0.9,  0.1 ), #I. Versic. dominates; setosa absent
                         c(0.0, 0.1,  0.9 )), #I. virg. dominates; setosa absent
                         ncol = 3, byrow = TRUE, dimnames = list(paste0("Comm.",1:3),
                          unique(iris$Species)))
TPDc_iris <- TPDc(TPDs = TPDs_iris, sampUnit = abundances_comm_iris)

#3. Estimate functional dissimilarity
example_dissimilarity_comm <- dissim (TPDc_iris)
example_dissimilarity_sps <- dissim (TPDs_iris)
}
