# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' CD-score
#' 
#' This function calculate CD-score <doi:10.1186/1297-9686-28-4-359> by given training set and test set. 
#' 
#' @author Jen-Hsiang Ou
#' 
#' @param X A numeric matrix. The training set genotypic information matrix can be given as genotype matrix (coded as -1, 0, 1) or principle component matrix (row: sample; column: marker).
#' @param X0 A numeric mareix. The test set genotypic information matrix can be given as genotype matrix (coded as -1, 0, 1) or principle component matrix (row: sample; column: marker).
#' @return A floating-point number, CD score.
#' 
#' @import Rcpp
#' 
#' @export
#' 
#' @examples
#' data(geno)
#' \dontrun{cd_score(geno[1:50, ], geno[51:100])}
#' 
cd_score <- function(X, X0) {
    .Call('_TSDFGS_cd_score', PACKAGE = 'TSDFGS', X, X0)
}

#' PEV score
#' 
#' This function calculate prediction error variance (PEV) score <doi:10.1186/s12711-015-0116-6> by given training set and test set. 
#' 
#' @param X A numeric matrix. The training set genotypic information matrix can be given as genotype matrix (coded as -1, 0, 1) or principle component matrix (row: sample; column: marker).
#' @param X0 A numeric mareix. The test set genotypic information matrix can be given as genotype matrix (coded as -1, 0, 1) or principle component matrix (row: sample; column: marker).
#' 
#' @return A floating-point number, PEV score.
#' 
#' @author Jen-Hsiang Ou
#' 
#' @import Rcpp
#' @export
#' @examples
#' data(geno)
#' \dontrun{pev_score(geno[1:50, ], geno[51:100])}
#' 
pev_score <- function(X, X0) {
    .Call('_TSDFGS_pev_score', PACKAGE = 'TSDFGS', X, X0)
}

#' r-score
#' 
#' This function calculate r-score <doi:10.1007/s00122-019-03387-0> by given training set and test set. 
#' 
#' @author Jen-Hsiang Ou
#' 
#' @param X A numeric matrix. The training set genotypic information matrix can be given as genotype matrix (coded as -1, 0, 1) or principle component matrix (row: sample; column: marker).
#' @param X0 A numeric mareix. The test set genotypic information matrix can be given as genotype matrix (coded as -1, 0, 1) or principle component matrix (row: sample; column: marker).
#' @return A floating-point number, r-score.
#' 
#' @import Rcpp
#' 
#' @export
#' @examples
#' data(geno)
#' \dontrun{r_score(geno[1:50, ], geno[51:100])}
#' 
r_score <- function(X, X0) {
    .Call('_TSDFGS_r_score', PACKAGE = 'TSDFGS', X, X0)
}

