% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TTS_10.R
\name{TTS_10}
\alias{TTS_10}
\title{Time-Temperature Superposition (TTS) analysis}
\usage{
TTS_10(
  x,
  reference.temperature = 40,
  n = 100,
  nB = 100,
  method = c("derived", "WLF", "Arrhenius")
)
}
\arguments{
\item{x}{Matrix or data frame composed of three columns: a numeric column
vector with the experimental frequencies (in logarithmic scale, base-ten),
the response variable (E' or G' modulus, compliance, etc.) base-ten
logarithm vector and, finally the corresponding temperatures vector.}

\item{reference.temperature}{Value of the selected reference temperature
at which the Master Curve of the response variable (E' or G' modulus,
compliance, etc.) will be obtained, the default value of temperature is 40.}

\item{n}{Number of partitions in the frequency domain in order to fit the
B-spline basis. The default value is 100.}

\item{nB}{Number of bootstrap replicates to estimate confidence intervals
of Master Curve fitting. The default is 100.}

\item{method}{A string vector composed of one of the following options:
"derived" (by default), "WLF" and "Arrhenius".}
}
\value{
The function returns a list composed of the following outputs:

\item{data}{Input experimental data.} \item{aT}{Numerical vector of
horizontal shifts between the modulus curves.} \item{bT}{Numerical vector
of vertical shifts between the modulus curves.} \item{TTS.data}{Master
Curve Data frame defined by three columns: Log10_time, Log10_Compliance and
Temperature.} \item{ref.temp}{Reference temperature value.}
\item{TTS.gam}{Data frame of the Generalized Additive Model with B-splines
(GAM) estimate of the Master Curve. It contains two columns: time and
Prediction.} \item{I.lower}{Lower limit of bootstrap confidence interval
corresponding to the estimated B-splines Master Curve.}
\item{I.upper}{Upper limit of bootstrap confidence interval corresponding
to the estimated B-splines Master Curve.} \item{residuals}{Residuals
corresponding to the GAM with B-splines Master Curve fitting.}
}
\description{
This function provides an estimate of the Master Curve in a similar way to
the TTS function, with the difference that, in this case, a thin plate
spline fit is performed (instead the B-splines smoothing), within the
framework of the application of generalized additive models (GAM), as
implemented in the mgcv package.
}
\examples{

## Epoxy
data(Epoxy)
x=Epoxy
## TTS_10 function applied to Epoxy.
Q=TTS_10(x,reference.temperature=40, method=c("derived","WLF","Arrhenius"))
names(Q)
## Horizontal shifts vector of compliance versus time curves.
Q$aT
## Reference temperature
Q$ref.temp
PLOT <- PLOT.TTS(Q)
## Generic plots of: data, aT, bT, TTS.data and TTS.gam
PLOT$PLOT.data(main="PLOT: Data",xlab="Log_time",
ylab="Log_Compliance")
PLOT$PLOT.aT(main="PLOT: horizontal shift factors",
xlab="Temperature", ylab="aT")
PLOT$PLOT.bT(main="PLOT: vertical shift factors",
xlab="Temperature",ylab="bT")
PLOT$PLOT.TTS.data(xlab="Log_time",
ylab="Log_Compliance")
PLOT$PLOT.TTS.gam( xlab="Log_time",
ylab="Log_Compliance",
main = "Fitted gam, Bootstrap confidence intervals",
sub = "Reference temperature = 40 Celsius degrees")
}
\references{
Naya, S., Meneses A., Tarrio-Saavedra, J., Artiaga R.,
Lopez-Beceiro, J. and Gracia-Fernandez C. (2013) New method for estimating
shift factors in time-temperatura superposition models. Journal of Thermal
Analysis and Calorimetry. ISSN 1388-6150. DOI 10.1007/s10973-013-3193-1.\cr

Williams, M. L. (1964) Structural analysis of Viscoelastic materials. AIAA
Journal, 785-808.\cr

Artiaga R., Garcia A. Fundamentals of DMA. In: 'Thermal analysis.
Fundamentals and applications to material characterization' (ed.: Artiaga
R.) Publicaciones de la Universidade da Coruna, A Coruna, Spain, 183-206
(2005).\cr

Wood, S.N. (2017) Generalized Additive Models: An   Introduction with R
(2nd edition). Chapman and   Hall/CRC.\cr
}
\author{
Antonio Meneses \email{antoniomenesesfreire@hotmail.com}, Salvador
Naya \email{salva@udc.es} and Javier Tarrio-Saavedra
\email{jtarrio@udc.es}
}
\keyword{TTS_10}
