#' @title 0-normalized game
#' @description Given a game, this function returns the characteristic function of its 0-normalization.
#' @param v A characteristic function, as a vector.
#' @param binary A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.
#' @return The characteristic function of the 0-normalized game, as a vector in binary order if \code{binary=TRUE} and in lexicographic order otherwise.
#' @details The 0-normalization of a given \eqn{v\in G^N} is defined by
#' \eqn{v_0(S)=v(S)-\sum_{i\in S} v(i)} for each \eqn{S \in 2^N}.
#' @examples
#' zeronormalizedgame(c(0,3,7,15,17,27,30))
#' zeronormalizedgame(c(1,5,10,6,11,15,16))
#' v.random <- rnorm(2^5-1,58,13)
#' zeronormalizedgame(v.random) == -savingsgame(v.random)
#' @seealso \link{normalizedgame}, \link{savingsgame}, \link{strategicallyequivalentcheck}, \link{zeromonotoniccheck}, \link{zeronormalizedcheck}
#' @export

zeronormalizedgame <- function(v, binary = FALSE) { # Principio de la función

  nC <- length(v) # Número de coaliciones.
  n <- log(nC + 1) / log(2) # Número de jugadores.
  if (n > floor(n)) {
    stop("'v' must have length 2^n-1 for some n.")
  }

  if (binary == FALSE) {
    # Ahora ya no hacemos lex2bin sino mismo proceso de normalizedgame.
    v0 <- c(rep(0,nC-1), v[nC]-sum(v[1:n])) #NOVA
    for (jj in (n+1):(nC-1)){ #BUCLE PEQUENO: SÓ NOS QUE SEI QUE PODEN CAMBIAR
      P <-getcoalition(codelex2bin(n,jj)) #NOVA: OS XOGADORES INDIVIDUAIS ESTÁN NESTA POSICIÓN P
      v0[jj]<-v[jj]-sum(v[P]) #NOVA: CONTA FINAL PARA CALCULAR O V0 DA COALICIÓN jj
    }
  } else {
    # A partir de aquí, código original para caso binary=TRUE.
    v0 <- v
    for (jj in 1:nC) {
      # Calculamos los jugadores pertenecientes a cada coalición y su valor en v.
      num <- jj
      J <- floor(log2(num)) + 1 # jugador más grande
      P <- c()
      for (ii in 1:J) # algoritmo de paso de un número en decimal a binario
      {
        if (num %% 2 == 1) {
          P <- c(P, ii)
        }
        num <- num %/% 2
      }
      v0[jj] <- v[jj] - sum(v[2.^(P - 1)]) # v0(S)=v(S)-sum(v(i))
    }
  }

  return(v0)
} # Fin de la función
