% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constantsumgame.R
\name{constantsumgame}
\alias{constantsumgame}
\title{Constant sum game}
\usage{
constantsumgame(halfv, vN)
}
\arguments{
\item{halfv}{The first half (according to lexicographic or binary order) of the characteristic function (excluding the grand coalition), as a vector.}

\item{vN}{The utility of the grand coalition.}
}
\value{
The characteristic function of the constant sum game. It is to be interpreted according to the order that \code{halfv} is introduced in.
}
\description{
This function computes the characteristic function of the specified constant sum game.
}
\details{
A game \eqn{v\in G^N} is a constant sum game if, for each \eqn{S \in 2^{N}},
\eqn{v(S) + v(N \setminus S) = v(N)}. Thus, if \eqn{v} is a constant sum game and \eqn{F} is
a family of \eqn{2^{n-1}-1} coalitions such that \eqn{S \cup T \neq N} for any \eqn{S,T \in F},
the full characteristic function of \eqn{v} is strictly determined by the utilities of
the coalitions in \eqn{F} and the utility of the grand coalition.
}
\examples{
constantsumgame(c(0,0,0), 1) # the dollar game
# Building a random constant sum game:
players <- sample(3:6,1) # random number of players between three and six
halfv <- runif(2^(players-1)-1, 0, 10) # random halfv
vN <- runif(1,30,50) # random vN
constantsumgame(halfv, vN)
}
