% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corevertices234.R
\name{corevertices234}
\alias{corevertices234}
\title{Core vertices of games with two, three or four players}
\usage{
corevertices234(v, binary = FALSE)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}
}
\value{
If the core of \code{v} is non-empty, the core vertices are returned, as a matrix in which each row is a vertex.
}
\description{
Given a game with no more than four players, this function computes its core vertices.
}
\details{
The core of a game \eqn{v\in G^N} is the set of all its stable imputations:
\deqn{C(v)=\{x\in\mathbb{R}^n : x(N)=v(N), x(S)\ge v(S)\ \forall S \in 2^N\},}
where \eqn{x(S)=\sum_{i\in S} x_i}.
}
\note{
Function \code{corevertices} can also compute the core vertices of games with less than five players, but takes a different approach.
}
\examples{
# 2 players:
corevertices234(c(-58,4,13))

# 3 players:
corevertices234(c(1,5,10,6,11,15,16)) # additive game

# 4 players:
corevertices234(c(0,0,0,0,4,3,5,2,4,5,10,19,20,30,100)) # convex game
corevertices234(c(0,0,0,0,1,2,1,1,1,1,4,3,2,1,7)) # not convex game

# What if the game is a cost game?
cost.v <- c(2,2,2,3,4,4,5) # cost game
-corevertices234(-cost.v) # core vertices of the cost game
}
\seealso{
\link{balancedcheck}, \link{corevertices}, \link{plotcoreset},
}
