% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapleyvalue.R
\name{shapleyvalue}
\alias{shapleyvalue}
\title{Shapley value}
\usage{
shapleyvalue(v, binary = FALSE)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}
}
\value{
The Shapley value of the game, as a vector.
}
\description{
Given a game, this function computes its Shapley value.
}
\details{
Given \eqn{v\in G^N}, the Shapley value of each player \eqn{i \in N} can be defined as
\deqn{Sh_{i}(v) = \sum_{S \subset N \setminus \{i\}} \frac{s!(n-s-1)!}{n!} (v(S \cup \{i\})-v(S)).}
It is also possible to compute it as
\deqn{Sh_{i}(v) = \sum_{\emptyset \neq S \subset N} M_{i,S} v(S),}
where \eqn{M_{i,S} = \frac{(s-1)!(n-s)!}{n!}} if \eqn{i \in S} and \eqn{M_{i,S} = -\frac{s!(n-s-1)!}{n!}} if \eqn{i \notin S}.
}
\examples{
shapleyvalue(c(0,0,3,0,3,8,6,0,6,9,15,8,16,17,20), binary=TRUE)
shapleyvalue(claimsgame(E=69.420,d=runif(10,5,10)))
}
\references{
Le Creurer, I. J., Mirás Calvo, M. A., Núñez Lugilde, I., Quinteiro Sandomingo, C., & Sánchez Rodríguez, E. (2024). On the computation of the Shapley value and the random arrival rule. Available at \url{https://papers.ssrn.com/sol3/papers.cfm?abstract_id=4293746}.

Shapley, L. S. (1953). A value for n-person games. \emph{Contribution to the Theory of Games}, 2.
}
\seealso{
\link{marginalvector}
}
