% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superadditivecheck.R
\name{superadditivecheck}
\alias{superadditivecheck}
\title{Superadditive check}
\usage{
superadditivecheck(v, binary = FALSE, instance = FALSE)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}

\item{instance}{A logical value. By default, \code{instance=FALSE}.}
}
\value{
\code{TRUE} if the game is superadditive, \code{FALSE} otherwise. If \code{instance=TRUE} and the game is not superadditive, the function also returns the positions (binary order positions if \code{binary=TRUE}; lexicographic order positions otherwise) of a pair of coalitions violating superadditivity.
}
\description{
This function checks if the given game is superadditive.
}
\details{
A game \eqn{v\in G^N} is superadditive if \eqn{v(S \cup T) \ge v(S)+v(T)} for all \eqn{S,T \in 2^N} with \eqn{S \cap T = \emptyset}.

A game \eqn{v\in G^N} is subadditive if \eqn{-v} is superadditive.
}
\examples{
v <- c(2, 2, 4, 2, 4, 5, 6)
superadditivecheck(v, binary = TRUE, instance = TRUE)

# How to check if a game is subadditive:
v.sub <- c(40, 30, 50, 60, 70, 65, 90) # subadditive game
superadditivecheck(-v.sub)
}
\seealso{
\link{additivecheck}, \link{convexcheck}, \link{monotoniccheck}, \link{strategicallyequivalentcheck}
}
