% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R, R/methods-TaxaNorm_Results.R
\docType{class}
\name{TaxaNorm_Results-class}
\alias{TaxaNorm_Results-class}
\alias{TaxaNorm_Results}
\alias{input_data,TaxaNorm_Results-method}
\alias{TaxaNorm_Results-input_data}
\alias{input_data<-,TaxaNorm_Results-method}
\alias{rawdata,TaxaNorm_Results-method}
\alias{TaxaNorm_Results-rawdata}
\alias{rawdata<-,TaxaNorm_Results-method}
\alias{normdata,TaxaNorm_Results-method}
\alias{TaxaNorm_Results-normdata}
\alias{normdata<-,TaxaNorm_Results-method}
\alias{ecdf,TaxaNorm_Results-method}
\alias{TaxaNorm_Results-ecdf}
\alias{ecdf<-,TaxaNorm_Results-method}
\alias{model_pars,TaxaNorm_Results-method}
\alias{TaxaNorm_Results-model_pars}
\alias{model_pars<-,TaxaNorm_Results-method}
\alias{converge,TaxaNorm_Results-method}
\alias{TaxaNorm_Results-converge}
\alias{converge<-,TaxaNorm_Results-method}
\alias{llk,TaxaNorm_Results-method}
\alias{TaxaNorm_Results-llk}
\alias{llk<-,TaxaNorm_Results-method}
\alias{final_df,TaxaNorm_Results-method}
\alias{TaxaNorm_Results-final_df}
\alias{final_df<-,TaxaNorm_Results-method}
\title{TaxaNorm Results}
\usage{
TaxaNorm_Results(
  input_data,
  rawdata,
  normdata,
  ecdf,
  model_pars,
  converge,
  llk,
  final_df
)

\S4method{input_data}{TaxaNorm_Results}(x)

\S4method{input_data}{TaxaNorm_Results}(x) <- value

\S4method{rawdata}{TaxaNorm_Results}(x)

\S4method{rawdata}{TaxaNorm_Results}(x) <- value

\S4method{normdata}{TaxaNorm_Results}(x)

\S4method{normdata}{TaxaNorm_Results}(x) <- value

\S4method{ecdf}{TaxaNorm_Results}(x)

\S4method{ecdf}{TaxaNorm_Results}(x) <- value

\S4method{model_pars}{TaxaNorm_Results}(x)

\S4method{model_pars}{TaxaNorm_Results}(x) <- value

\S4method{converge}{TaxaNorm_Results}(x)

\S4method{converge}{TaxaNorm_Results}(x) <- value

\S4method{llk}{TaxaNorm_Results}(x)

\S4method{llk}{TaxaNorm_Results}(x) <- value

\S4method{final_df}{TaxaNorm_Results}(x)

\S4method{final_df}{TaxaNorm_Results}(x) <- value
}
\arguments{
\item{input_data}{passed to \code{input_data} slot}

\item{rawdata}{Passed to \code{rawdata} slot}

\item{normdata}{Passed to \code{normdata} slot}

\item{ecdf}{Passed to \code{ecdf} slot}

\item{model_pars}{Passed to \code{model_pars} slot}

\item{converge}{Passed to \code{converge} slot}

\item{llk}{Passed to \code{llk} slot}

\item{final_df}{Passed to \code{final_df} slot}

\item{x}{TaxaNorm_Results object}

\item{value}{Replacement value}
}
\description{
S4 class to store TaxaNorm Results
}
\details{
All results from the TaxaNorm method and what was used to get those results
}
\section{Functions}{
\itemize{
\item \code{input_data(TaxaNorm_Results)}: Return \code{input_data} slot

\item \code{rawdata(TaxaNorm_Results)}: Return \code{rawdata} slot

\item \code{normdata(TaxaNorm_Results)}: Return \code{normdata} slot

\item \code{ecdf(TaxaNorm_Results)}: Return \code{ecdf} slot

\item \code{model_pars(TaxaNorm_Results)}: Return \code{model_pars} slot

\item \code{converge(TaxaNorm_Results)}: Return \code{converge} slot

\item \code{llk(TaxaNorm_Results)}: Return \code{llk} slot

\item \code{final_df(TaxaNorm_Results)}: Return \code{final_df} slot

}}
\section{Slots}{

\describe{
\item{\code{input_data}}{\code{ANY} phyloseq input data}

\item{\code{rawdata}}{\code{data.frame} Data frame of counts to use}

\item{\code{normdata}}{\code{data.frame} Normalized Data}

\item{\code{ecdf}}{\code{data.frame} ecdf}

\item{\code{model_pars}}{\link{TaxaNorm_Model_Parameters} list of model parameters}

\item{\code{converge}}{\verb{vector(<logical>)} converge}

\item{\code{llk}}{\code{ANY} llk}

\item{\code{final_df}}{\code{ANY} final_df}
}}

\examples{
coefficients <-  matrix(c(1,2,3,4,5,6,7,8,9),nrow=3,ncol=3,byrow=TRUE)
mu <- matrix(c(1,2,3,4,5,6,7,8,9),nrow=3,ncol=3,byrow=TRUE)
theta <-  matrix(c(1,2,3,4,5,6,7,8,9),nrow=3,ncol=3,byrow=TRUE)
pi <- matrix(c(1,2,3,4,5,6,7,8,9),nrow=3,ncol=3,byrow=TRUE)
model_pars <- TaxaNorm_Model_Parameters(coefficients = coefficients,mu = mu,theta = theta,pi = pi)
data("TaxaNorm_Example_Input", package = "TaxaNorm")
rawdata <- data.frame(Taxa1 = c(1,2,3),Taxa2 = c(3,4,5),Taxa3 = c(6,7,8))
normdata <- data.frame(Taxa1 = c(-1.4,-1.09,-0.73),
Taxa2 = c( -0.36,0,0.36), Taxa3 = c(0.73,1.09,1.46))
ecdf <- data.frame(0.05,0.23,0.89)
converge <- c(TRUE,TRUE,FALSE)
llk <- c(1,1.5,0.5)
final_df <- data.frame(Taxa1 = c(1,2,3),Taxa2 = c(3,4,5),Taxa3 = c(6,7,8))
TaxaNorm_Results(input_data = TaxaNorm_Example_Input,
                                  rawdata = rawdata,
                                   normdata = normdata,
                                   ecdf = ecdf,
                                   model_pars = model_pars,
                                   converge = converge,
                                   llk = llk,
                                   final_df = final_df)
}
