% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eligibility_functions.R
\name{flagIneligible}
\alias{flagIneligible}
\title{(Internal) Obtain item/set level eligibility flags}
\usage{
flagIneligible(
  exposure_record,
  simulation_constants,
  item_index_by_stimulus,
  seed,
  j,
  usage_flag = NULL
)
}
\arguments{
\item{exposure_record}{a named list containing exposure records.}

\item{simulation_constants}{a named list containing simulation constants.}

\item{item_index_by_stimulus}{a list containing item indices by stimulus.}

\item{seed, j}{(optional) a random seed, and the examinee index. Used to determine the random seed as \code{seed * 123 + j}.}
}
\value{
\code{\link{flagIneligible}} returns a named list containing the following:
\describe{
  \item{\code{i}}{a (\emph{n_segment}, \emph{ni}) matrix of 1 and 0 values.}
  \item{\code{s}}{a (\emph{n_segment}, \emph{ns}) matrix of 1 and 0 values. Only returned when \code{simulation_constants$group_by_stimulus} is \code{TRUE}.}
}
In each matrix,
1 indicates the item/set is eligible to be selected in a shadowtest, and
0 indicates the item/set is not eligible to be selected in a shadowtest.
The higher the observed exposure rate, the more likely the item/set will be flagged as 0.
The rows represent theta segments, and the flags in the row corresponding to the examinee's current interim theta estimate is used for the shadowtest assembly.
}
\description{
\code{\link{flagIneligible}} is an internal function for obtaining item/set-level eligibility flags based on segment-wise exposure rates.
}
\keyword{internal}
