% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eligibility_functions.R
\name{getEligibilityFlagInSegment}
\alias{getEligibilityFlagInSegment}
\title{(Internal) Parse eligibility flags for a specific theta segment}
\usage{
getEligibilityFlagInSegment(eligiblity_flag, segment, simulation_constants)
}
\arguments{
\item{eligiblity_flag}{a list containing segment-wise eligibility flags.}

\item{segment}{the segment index to read from.}

\item{simulation_constants}{a named list containing simulation constants.}
}
\value{
\code{\link{getEligibilityFlagInSegment}} returns a named list containing the following:
\describe{
  \item{\code{i}}{a length-\emph{ni}) vector of 1 and 0 values.}
  \item{\code{s}}{a length-\emph{ns}) vector of 1 and 0 values. Only returned when \code{simulation_constants$group_by_stimulus} is \code{TRUE}.}
}
In each vector,
1 indicates the item/set is eligible to be selected in a shadowtest, and
0 indicates the item/set is not eligible to be selected in a shadowtest.
The higher the observed exposure rate, the more likely the item/set will be flagged as 0.
}
\description{
\code{\link{getEligibilityFlagInSegment}} is an internal function for obtaining item/set-level eligibility flags for a specific theta segment.
}
\keyword{internal}
