% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_pool_cluster_operators.R
\docType{methods}
\name{makeItemPoolCluster}
\alias{makeItemPoolCluster}
\alias{makeItemPoolCluster,item_pool-method}
\alias{==.item_pool_cluster}
\title{Create an item pool cluster object}
\usage{
makeItemPoolCluster(x, ..., names = NULL)

\S4method{makeItemPoolCluster}{item_pool}(x, ..., names = NULL)

\method{==}{item_pool_cluster}(item_pool_cluster1, item_pool_cluster2)
}
\arguments{
\item{x, ...}{\code{\linkS4class{item_pool}} objects.}

\item{names}{(optional) names to use for \code{\linkS4class{item_pool}}.}

\item{item_pool_cluster1}{an \code{\linkS4class{item_pool_cluster}} object.}

\item{item_pool_cluster2}{an \code{\linkS4class{item_pool_cluster}} object.}
}
\description{
Create a \code{\linkS4class{item_pool_cluster}} object.

\code{item_pool_cluster1 == item_pool_cluster2} tests equality of two item_pool_cluster objects.
}
\examples{

cluster <- makeItemPoolCluster(itempool_science, itempool_reading)
cluster1 <- makeItemPoolCluster(itempool_science, itempool_reading)
cluster2 <- makeItemPoolCluster(cluster1@pools[[1]], cluster1@pools[[2]])
cluster1 == cluster2  ## TRUE

}
