% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structuringdocument.R
\name{DivideFile}
\alias{DivideFile}
\title{DivideFile}
\usage{
DivideFile(x)
}
\arguments{
\item{x}{A character vector, each element represents one line of the latex document}
}
\value{
Returns a list with two character vectors:
\describe{
\item{preamble}{A character vector that includes \emph{every line} of \code{x} up the begin document command}
\item{document}{A character vector that includes \emph{every line} from the begin document command to the first end document command} }
}
\description{
Function that takes a vector of text lines, \code{x}, and divides it in preamble and document.
}
\details{
It ignores everything after the first end document command and it will throw and error if it finds more than one begin document command before that
}
\examples{
file <- system.file(
    "extdata",
    "ExampleTexDocuments",
    "exam_testing_jsonparser.tex",
    package = "TexExamRandomizer"
)
x <- readLines(file)
DivideFile(x)
}
\seealso{
Other Structuring Document: 
\code{\link{CompileDocument}()},
\code{\link{FindStructure}},
\code{\link{IsWellSectioned}()},
\code{\link{StructureDocument}()}
}
\concept{Structuring Document}
