% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Grading.R
\name{GradeExams}
\alias{GradeExams}
\title{GradeExams}
\usage{
GradeExams(
  ExamAnswerParsedList,
  name.ColCorrect,
  name.ColIncorrect,
  MaxOutputGrade = 100,
  ExtraPoints = 0,
  ExtraPointsForAll = 0
)
}
\arguments{
\item{ExamAnswerParsedList}{List parsed by \code{\link{WhichAnswerOriginal}}}

\item{name.ColCorrect, name.ColIncorrect}{The names of the correct and incorrect columns in each answer sheet of the \code{ExamAnswerParsedList} respectively.}

\item{MaxOutputGrade}{Maximum score that one should get if you get a perfect score, before couning the \code{ExtraPoints}}

\item{ExtraPoints}{Extra points to be added after scoring the exam. This points are added after the scaling is done with \code{MaxOutputGrade}.}

\item{ExtraPointsForAll}{Scalar numeric value, extra points to be given to all student.}
}
\value{
It returns the \code{StudentInfo} attribute of the parsed list adding the following columns to it

 \describe{
     \item{\code{$addedPoints}}{Individual part of ExtraPoints}
     \item{\code{$addedAllPoints}}{Extra Points For All}
     \item{\code{$maxGrade}}{ Max number of questions for the exam. (It would be different if when removing a question, some students didn't have a question in that exam)}
     \item{\code{$Grade}}{Number of correct answers that a student wrote in an exam}
     \item{\code{$Grade_Total_Exam}}{This is the \code{total_grade} as explained on the Extra Points section.}
 }
}
\description{
Grades an exam given a parsed list by \code{\link{WhichAnswerOriginal}}
}
\details{
The score is first added on the base of the number of questions that are found on every parsed list.

If a question is removed from an exam, not all students may have that question as explained in the "Removing questions from the exam" section. If the total rows of a certain student list is \eqn{n}, the score is \deqn{c / n * MaxOutputGrade}, where \eqn{c} is the number of correct answers.

After that is done, the \code{ExtraPoints} are added.
}
\section{Extra Points}{


The structure of \code{ExtraPoints} and the convention on how the score is calculated taking it into account is worth mentioning in it's own section.
The score is calculated as:

\deqn{total_{grade} = (c + extra_{all}) / (maxn + extra_{all}) * MaxOutputGrade + extra_{individual}}
Where \describe{
\item{\code{c}}{Number of correct questions}
\item{\code{extra_all}}{Number of extra points for all.

This is thought of to be used as a question that you removed from the exam last minute,
but that you want to actually count it as correct for every single student. I.e., a question that everyone got correct but it is not taken into consideration in the grading.}
\item{\code{extra_individual}}{Number of extra points for that student.}
\item{\code{max_n}}{Maximum number of questions in the students exam, which may differ from other students if you had to removed a bugged questions that not everyone had}
\item{\code{MaxOutputGrade}}{The scaling to be done. This should be the maximum grade any student "should" get. (The individual extra points are added after the scaling is done)}
}
}

\section{Removing Questions from the exam}{


Note that if after creating the exam, you found that a question is bugged and can't be used to grade the exam, all you have to do is tell the student to answer "something" and you only have to remove it from the original/reference version in the Full Answer Sheet. When you apply the grading function, that question will then be ignored.

Notice how this creates output lists with different lengths in the case that two students didn't have that same question in their exam.

For example, if a exam has 15 questions out of a 50 question document. If student A has a bugged question and student B doesn't, the answer sheet produced for student A will have 14 rows while the one for student B will have 15 rows.
}

\examples{

#First part coming from FindMatchingRow example

asheet_file <-
    system.file(
        "extdata",
        "ExampleTables",
        "ExampleAnswerSheet.csv",
        package = "TexExamRandomizer")
responses_file <-
    system.file(
        "extdata",
        "ExampleTables",
        "ExampleResponses.csv",
        package = "TexExamRandomizer")
FullAnswerSheet <-
    read.csv(
        asheet_file,
        header = TRUE,
        stringsAsFactors = FALSE,
        na.strings = c("", "NA", "Na"),
        strip.white = TRUE)
Responses <- read.csv(
    responses_file,
    header = TRUE,
    stringsAsFactors = FALSE,
    na.strings = c("", "NA", "Na"),
    strip.white = TRUE)
compiledanswers <-
    WhichAnswerOriginal(
        StudentAnswers = Responses,
        FullExamAnswerSheet = FullAnswerSheet,
        names.StudentAnswerQCols = grep(
            names(Responses),
            pattern = "^Q.*[[:digit:]]",
            value = TRUE),
        names.StudentAnswerExamVersion = grep(
            names(Responses),
            pattern = "Version",
            value = TRUE),
        OriginalExamVersion = 0,
        names.FullExamVersion = "Version",
        names.FullExamOriginalCols = grep(
            names(FullAnswerSheet),
            pattern = "_original",
            value = TRUE),
        names.CorrectAndIncorrectCols = c(
            "choice",
            "CorrectChoice")
    )
# Actual Code


ExtraPoints_individual <- runif(nrow(Responses), min = 1, max = 10)
ExtraPoints_forall <- 2
GradedStudentTable <-
    GradeExams(
        compiledanswers,
        name.ColCorrect = "CorrectChoice",
        name.ColIncorrect = "choice",
        MaxOutputGrade = 100,
        ExtraPoints = ExtraPoints_individual,
        ExtraPointsForAll = ExtraPoints_forall
    )




}
\seealso{
Other Grading Exams: 
\code{\link{ObtainExamStats}()}
}
\concept{Grading Exams}
