% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/start_chat.R
\name{start_chat}
\alias{start_chat}
\title{Start a new chat session}
\usage{
start_chat(
  initial_role = "system",
  initial_content = "You are a helpful assistant.",
  show = FALSE,
  chatlog_id = NULL
)
}
\arguments{
\item{initial_role}{A character string representing the role issueing the initial content (per default: "system")}

\item{initial_content}{A character string representing the initial message from the system}

\item{show}{Logical, if TRUE, the current chat log is displayed via View(). Default is FALSE.}

\item{chatlog_id}{A character string representing the ID of this conversation. Per default, this will be set automatically.}
}
\value{
A character string indicating the name of the log environment created for the chat session.
}
\description{
This function starts a new chat session by initializing a messages object with an initial system message,
creating a new log environment to store the messages, and adding the messages object to the log environment.
}
\examples{
# Start a new chat session with the default system message
chatlog_id <- start_chat()

# Start a new chat session with a custom system message
chatlog_id <- start_chat("How can I assist you today?")

}
