\name{PlotLOOCV}
\alias{PlotLOOCV}
\alias{PLOTLOOCV}
\title{List taxa names present in the BEAST input file}
\description{
    The LOOCV (Leave-one-out-cross-validation) is a statistical procedure aiming to detect 
	whether some particular sequences, when used as calibration in a tip dating analyse,
	could lead to systematic bias. Once the XMLs produced with the "TaxaOut" function analyzed with BEAST,
	the PlotLOOCV function allows a graphical comparison of the estimated vs true sequence ages.
	Similarly to the PlotDRT function, PlotLOOCV requires uploading, reading and analysing the 
	"Log" files generated by BEAST.
}
\usage{
PlotLOOCV(name, burnin = 0.1)
}
\arguments{
    \item{name}{
        the name of the original XML file (excluding the .xml extension). In the same folder,
		should be present the i LogFiles generated from the i XMLs produced with the "TaxaOut" function 
		(i being the number of Taxa in the dataset). The name of the Log files should look like "name.Taxon[i].log".
    }
	\item{burnin}{
		the fraction of the first MCMC sampling to exclude from the Log files when computing the parameter
		estimates distribution (default = 0.1, which means 10%)
	}
}
\details{
    The function works only with a .xml file generated with BEAUti
}
\value{
    The function returns the names and order of the taxa present in an input xml file for the BEAST software.
}
\references{
	Rieux, A. and Khatchikian, C.E., 2017. TipDatingBeast: An R package to assist the implementation of 
	phylogenetic tip-dating tests using BEAST. Molecular ecology resources, 17(4), pp.608-613.
	Drummond AJ, Suchard MA, Xie D & Rambaut A (2012) Bayesian phylogenetics with BEAUti and the BEAST 1.7.
	Molecular Biology And Evolution 29: 1969-1973.
}
\examples{
\dontrun{
	# example create with example file
	PlotLOOCV("Flu_BEAST_1.8", burnin = 0.1)
	# produce LOOCV plot 
}
}
\keyword{BEAST Software}
\keyword{phylogenetics}
