% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ToothAlignment.R
\name{ToothAlignment}
\alias{ToothAlignment}
\title{ToothAlignment}
\usage{
ToothAlignment(mesh1, mesh2, mesh3 = NULL, set, outline, analyse = c("r", "c"))
}
\arguments{
\item{mesh1}{3D mesh: dental mesh (enamel)}

\item{mesh2}{3D mesh: dental mesh (dentin)}

\item{mesh3}{3D mesh: dental mesh (dental pulp)}

\item{set}{matrix: 5 landmarks acquired on the mesh (see details)}

\item{outline}{matrix: set of coordinates along the cerical outline}

\item{analyse}{character: "r" for root, "c" for crown}
}
\value{
almesh1: mesh of the aligned mesh1

almesh2: mesh of the aligned mesh2

almesh3: mesh of the aligned mesh3

alset: coordinates of the aligned landmark configuration

length: biomechanical length of the root (see details)

margins: coordinates of the landmarks in correspondence of the four margins

margins_sel: position of the margin along the outline

aloutline: coordinates of the aligned cervical outline

diamBL: bucco-lingual diameter

diamMD: mesio-distal diameter
}
\description{
Align dental meshes using as reference the cervical outline and five landmarks
}
\details{
The function needs five landmarks to align the dental meshes. Usually landmarks from 1 to 4 define the Lingual, Mesial, Buccal and Distal margins.
The fifth landmark defines the end of the z axis (biomechanical length). The centroid of the cervical outline defines the origin of axes.
}
\examples{
\donttest{
data("URI1_tooth")
Enamel<-URI1_tooth$mesh1
Dentin<-URI1_tooth$mesh2
Pulp<-URI1_tooth$mesh3
outline<-URI1_tooth$outline
set<-URI1_tooth$set

#Example on the root
AlignMeshesR<-ToothAlignment(mesh1=Enamel,mesh2=Dentin,mesh3=Pulp,set,outline,analyse = "r")
  require(rgl)
  open3d()
  shade3d(AlignMeshesR$almesh1$mesh,col="white",alpha=0.5)
  shade3d(AlignMeshesR$almesh2$mesh,col="pink",alpha=0.5,add=TRUE)
  shade3d(AlignMeshesR$almesh3$mesh,col="orange",alpha=0.5,add=TRUE)
  spheres3d(AlignMeshesR$alset,radius=0.25)
  spheres3d(AlignMeshesR$outline,radius=0.1,col="blue")
  lines3d(AlignMeshesR$outline)
  text3d(rbind(AlignMeshesR$outline[AlignMeshesR$margins_sel,],AlignMeshesR$alset[4,]),
  texts=1:5,cex=4)
  spheres3d(AlignMeshesR$alset[2,],radius=0.3,col="red")
  arrow3d(colMeans(AlignMeshesR$aloutline),AlignMeshesR$alset[4,],lwd=3,col="green",
  type="lines",s=1/10)
  lines3d(rbind(AlignMeshesR$alset[2,],AlignMeshesR$alset[1,]),lwd=3,col="green")
  axes3d()
}
#Example on the crown
\donttest{
AlignMeshesC<-ToothAlignment(mesh1=Enamel,mesh2=Dentin,mesh3=Pulp,set,outline,
analyse = "c")
  require(rgl)
  open3d()
  shade3d(AlignMeshesC$almesh1$mesh,col="white",alpha=0.5)
  shade3d(AlignMeshesC$almesh2$mesh,col="pink",alpha=0.5,add=TRUE)
  shade3d(AlignMeshesC$almesh3$mesh,col="orange",alpha=0.5,add=TRUE)
  spheres3d(AlignMeshesC$alset,radius=0.25)
  spheres3d(AlignMeshesC$outline,radius=0.1,col="blue")
  lines3d(AlignMeshesC$outline)
  text3d(rbind(AlignMeshesC$outline[AlignMeshesC$margins_sel,],AlignMeshesC$alset[4,]),
  texts=1:5,cex=4)
  spheres3d(AlignMeshesC$alset[2,],radius=0.3,col="red")
  arrow3d(colMeans(AlignMeshesC$aloutline),AlignMeshesC$alset[4,],lwd=3,col="green",
  type="lines",s=1/10)
  lines3d(rbind(AlignMeshesC$alset[2,],AlignMeshesC$alset[1,]),lwd=3,col="green")
  lines3d(rbind(AlignMeshesC$alset[2,],AlignMeshesC$alset[1,]),lwd=3,col="green")
  
  axes3d()
}
}
\author{
Antonio Profico; Mathilde Augoyard
}
