% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.R
\name{add_anti_join}
\alias{add_anti_join}
\title{Add an anti-join onto a tplyr_meta object}
\usage{
add_anti_join(meta, join_meta, on)
}
\arguments{
\item{meta}{A tplyr_meta object referring to the target data}

\item{join_meta}{A tplyr_meta object referring to the population data}

\item{on}{A list of quosures containing symbols - most likely set to USUBJID.}
}
\value{
A tplyr_meta object
}
\description{
An anti-join allows a tplyr_meta object to refer to data that should be
extracted from a separate dataset, like the population data of a Tplyr table,
that is unavailable in the target dataset. The primary use case for this is
the presentation of missing subjects, which in a Tplyr table is presented
using the function \code{add_missing_subjects_row()}. The missing subjects
themselves are not present in the target data, and are thus only available in
the population data. The \code{add_anti_join()} function allows you to provide the
meta information relevant to the population data, and then specify the \code{on}
variable that should be used to join with the target dataset and find the
values present in the population data that are missing from the target data.
}
\examples{

tm <- tplyr_meta(
  rlang::quos(TRT01A, SEX, ETHNIC, RACE),
  rlang::quos(TRT01A == "Placebo", TRT01A == "SEX", ETHNIC == "HISPANIC OR LATINO")
)

tm \%>\%
  add_anti_join(
    tplyr_meta(
      rlang::quos(TRT01A, ETHNIC),
      rlang::quos(TRT01A == "Placebo", ETHNIC == "HISPANIC OR LATINO")
    ),
    on = rlang::quos(USUBJID)
  )
}
